//LidScrewHead.scad;

//Module to define one hole 
//for the head of one screw 
//that fastens the lid to the floor; 

//This module constructs the hole 
//as an object to be removed from the floor 
//by a difference() command;
    
//On output from this module, the hole object  
//is centered about the Z axis, 
//with the head resting on the XY plane, and
//the hole for the thread along the Z axis;

//Any further adjustment of orientation
//and/or position must be done 
//by the calling module;
    
//Warning!
//Because this object will be used in a 
//subsequent difference() command, 
//it isn't safe to make any length longer
//than necessary and its length must be 
//reasonably accurate;

include <UNO_Dimensions.scad>;

module LidScrewHead()
{

echo("Begin LidScrewHead");

cylinder(h=LidScrewHeadDepth,
    d=LidScrewHeadPhi, center=false, $fn=32);
    
}

//
